/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.listeners;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.actionutils.ActionFactory;
import com.github.quiltservertools.ledger.database.DatabaseManager;
import com.github.quiltservertools.ledger.network.Networking;
import com.github.quiltservertools.ledger.utility.InspectionManagerKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a2\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a<\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b\u001a(\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0006\u0010!\u001a\u00020\r\u00a8\u0006\""}, d2={"onBlockAttack", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "world", "Lnet/minecraft/world/World;", "hand", "Lnet/minecraft/util/Hand;", "pos", "Lnet/minecraft/util/math/BlockPos;", "direction", "Lnet/minecraft/util/math/Direction;", "onBlockBreak", "", "state", "Lnet/minecraft/block/BlockState;", "blockEntity", "Lnet/minecraft/block/entity/BlockEntity;", "onBlockPlace", "context", "Lnet/minecraft/item/ItemPlacementContext;", "onJoin", "networkHandler", "Lnet/minecraft/server/network/ServerPlayNetworkHandler;", "packetSender", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "server", "Lnet/minecraft/server/MinecraftServer;", "onLeave", "handler", "onUseBlock", "blockHitResult", "Lnet/minecraft/util/hit/BlockHitResult;", "registerPlayerListeners", "ledger"})
public final class PlayerEventListenerKt {
    public static final void registerPlayerListeners() {
        PlayerBlockBreakEvents.AFTER.register(PlayerEventListenerKt::onBlockBreak);
        ServerPlayConnectionEvents.JOIN.register(PlayerEventListenerKt::onJoin);
        ServerPlayConnectionEvents.DISCONNECT.register(PlayerEventListenerKt::onLeave);
        AttackBlockCallback.EVENT.register(PlayerEventListenerKt::onBlockAttack);
        UseBlockCallback.EVENT.register(PlayerEventListenerKt::onUseBlock);
    }

    public static final void onLeave(@NotNull class_3244 handler, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"handler.player");
        Networking.INSTANCE.disableNetworking(class_32222);
    }

    private static final class_1269 onUseBlock(class_1657 player2, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (InspectionManagerKt.isInspecting(player2) && hand == class_1268.field_5808) {
            class_2168 class_21682 = player2.method_5671();
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"player.commandSource");
            class_2168 class_21683 = class_21682;
            class_21682 = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"blockHitResult.blockPos.\u2026fset(blockHitResult.side)");
            InspectionManagerKt.inspectBlock(class_21683, (class_2338)class_21682);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static final class_1269 onBlockAttack(class_1657 player2, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (InspectionManagerKt.isInspecting(player2)) {
            class_2168 class_21682 = player2.method_5671();
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"player.commandSource");
            InspectionManagerKt.inspectBlock(class_21682, pos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static final void onJoin(class_3244 networkHandler, PacketSender packetSender, MinecraftServer server) {
        BuildersKt.launch$default((CoroutineScope)Ledger.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(networkHandler, null){
            int label;
            final /* synthetic */ class_3244 $networkHandler;
            {
                this.$networkHandler = $networkHandler;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = this.$networkHandler.field_14140.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"networkHandler.player.uuid");
                        UUID uUID = object3;
                        object3 = this.$networkHandler.field_14140.method_5820();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"networkHandler.player.entityName");
                        this.label = 1;
                        Object object4 = DatabaseManager.INSTANCE.logPlayer(uUID, (String)object3, (Continuation<? super Unit>)((Continuation)this));
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void onBlockPlace(class_1937 world, class_1657 player2, class_2338 pos, class_2680 state, class_1750 context, class_2586 blockEntity) {
        DatabaseManager.INSTANCE.logAction(ActionFactory.blockPlaceAction$default(ActionFactory.INSTANCE, world, pos, state, player2, blockEntity, null, 32, null));
    }

    private static final void onBlockBreak(class_1937 world, class_1657 player2, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        DatabaseManager.INSTANCE.logAction(ActionFactory.blockBreakAction$default(ActionFactory.INSTANCE, world, pos, state, player2, blockEntity, null, 32, null));
    }
}

